let win, child, fp;
const {app, BrowserWindow, dialog, globalShortcut, session, shell} = require('electron'),
{existsSync, mkdirSync, writeFileSync} = require('fs'),
url = require('url').URL,
path = require('path').join,
dir = __dirname,
load = 'https://evilgames.eu/flashgames.htm',
name = ' ' + app.name + ' v' + app.getVersion(),
isWindows = process.platform === 'win32',
isLinux = process.platform === 'linux',
isMac = process.platform === 'darwin',
preferences = {plugins:true, sandbox:true, contextIsolation:true, worldSafeExecuteJavaScript:true, disableDialogs:true},
mainWindow = {backgroundColor:'#0f0f0f', width:1280, height:800, minWidth:923, minHeight:640, title:name, webPreferences:preferences},
childWindow = {backgroundColor:'#0f0f0f', width:1280, height:800, minWidth:923, minHeight:640, title:name + ' (Child)', show:false, webPreferences:preferences},
dataDir = path(dir, '../', 'data');

app.commandLine.appendSwitch('ignore-connections-limit', 'evilgames.eu')
isLinux ? fp = 'libpepflashplayer.so' : fp = 'pepflashplayer.dll';
if(isMac)fp = 'PepperFlashPlayer.plugin';
app.commandLine.appendSwitch('ppapi-flash-path', path(dir, '../', 'flashplayer', fp))
app.commandLine.appendSwitch('ppapi-flash-version', 'v32.0.0.465')
isLinux ? app.commandLine.appendSwitch('no-sandbox') : app.enableSandbox();

if(existsSync(dataDir)){app.setPath('userData', dataDir)}
let config = path(app.getPath('userData'),'Pepper Data','Shockwave Flash','System');

if(!existsSync(config))mkdirSync(config,{recursive:true})
if(!existsSync(path(config,'mms.cfg'))){
writeFileSync(path(config,'mms.cfg'),
`AVHardwareDisable=1
LocalStorageLimit=5
EnableInsecureByteArrayShareable=1
EventJitterMicroseconds=0
TimerJitterMicroseconds=0`)}

var dialogClose = ' Close window',dialogCloseM = 'Close selected window?',dialogQuit = ' Quit app',dialogQuitM = 'Close all windows?',dialogNo = 'Abort',dialogYes = 'Confirm';
if(app.getLocale().slice(0,2) === 'de'){dialogClose = ' Fenster schließen';dialogCloseM = 'Ausgewähltes Fenster schließen?';dialogQuit = ' App beenden';dialogQuitM = 'Alle Fenster schließen?';dialogNo = 'Abbrechen';dialogYes = 'Bestätigen'}
const closeDialog = {defaultId:1, cancelId:1, icon:path(dir, 'img', 'close.png'), buttons:[dialogYes,dialogNo], title:dialogClose, message:dialogCloseM},
quitDialog = {defaultId:1, cancelId:1, icon:path(dir, 'img', 'quit.png'), buttons:[dialogYes,dialogNo], title:dialogQuit, message:dialogQuitM}

app.on('browser-window-focus', () => {
globalShortcut.register('CmdOrCtrl+I', () => {BrowserWindow.getFocusedWindow().webContents.toggleDevTools()})
globalShortcut.register('CmdOrCtrl+O', () => {shell.openPath(app.getPath('userData'))})
globalShortcut.register('CmdOrCtrl+Q', () => {win.close()})
globalShortcut.register('CmdOrCtrl+R', () => {BrowserWindow.getFocusedWindow().reload()})
globalShortcut.register('CmdOrCtrl+W', () => {BrowserWindow.getFocusedWindow().close()})

globalShortcut.register('CmdOrCtrl+T', () => {
child = new BrowserWindow(childWindow)
child.removeMenu()
child.loadURL(load)
child.once('ready-to-show', () => {child.show();child.focus()})
child.on('page-title-updated', (e) => {e.preventDefault()})
child.on('close', (e) => {const choice = dialog.showMessageBoxSync(child,closeDialog);if(choice == 1){e.preventDefault()}})
child.on('closed', () => {child = null})
child.webContents.on('new-window', (e) => {e.defaultPrevented = true})
child.webContents.on('will-navigate', (e, nav) => {const parsed = new url(nav)
if(parsed.origin !== 'https://evilgames.eu') {e.preventDefault()}
if(parsed.href.indexOf('/evilectron/') > 0){e.preventDefault();shell.openExternal(parsed.href)}
if(parsed.pathname === '/index.htm' || parsed.pathname === '/about.htm') {e.preventDefault();shell.openExternal(parsed.href)}})})

globalShortcut.register('CmdOrCtrl+num0', () => {win.webContents.setZoomFactor(1.0)})
globalShortcut.register('CmdOrCtrl+numsub', () => {if(win.webContents.getZoomFactor().toFixed(1) != 0.1)win.webContents.setZoomFactor(win.webContents.getZoomFactor()-0.1)})
globalShortcut.register('CmdOrCtrl+numadd', () => {if(win.webContents.getZoomFactor().toFixed(1) != 5.0)win.webContents.setZoomFactor(win.webContents.getZoomFactor()+0.1)})})

app.on('browser-window-blur', () => {globalShortcut.unregisterAll()})
app.on('web-contents-created', (e, webContents) => {webContents.on('select-bluetooth-device', (e, devices, callback) => {e.preventDefault();callback('')})})

app.on('second-instance', (e) => {
child = new BrowserWindow(childWindow)
child.removeMenu()
child.loadURL(load)
child.once('ready-to-show', () => {child.show();child.focus()})
child.on('page-title-updated', (e) => {e.preventDefault()})
child.on('close', (e) => {const choice = dialog.showMessageBoxSync(child,closeDialog);if(choice == 1){e.preventDefault()}})
child.on('closed', () => {child = null})
child.webContents.on('new-window', (e) => {e.defaultPrevented = true})
child.webContents.on('will-navigate', (e, nav) => {const parsed = new url(nav)
if(parsed.origin !== 'https://evilgames.eu') {e.preventDefault()}
if(parsed.href.indexOf('/evilectron/') > 0){e.preventDefault();shell.openExternal(parsed.href)}
if(parsed.pathname === '/index.htm' || parsed.pathname === '/about.htm') {e.preventDefault();shell.openExternal(parsed.href)}})})
if (!app.requestSingleInstanceLock()) {return app.quit()}

app.on('ready', () => {
win = new BrowserWindow(mainWindow)
win.removeMenu()
if(isWindows)win.minimize()
win.maximize()
win.focus()
win.loadURL(load)
win.on('page-title-updated', (e) => {e.preventDefault()})
if(isLinux)win.setIcon(path(dir, 'img', 'icon-ghostly-nx.png'))
win.webContents.on('new-window', (e) => {e.defaultPrevented = true})
win.webContents.on('will-navigate', (e, nav) => {const parsed = new url(nav)
if(parsed.origin !== 'https://evilgames.eu') {e.preventDefault()}
if(parsed.href.indexOf('/evilectron/') > 0){e.preventDefault();shell.openExternal(parsed.href)}
if(parsed.pathname === '/index.htm' || parsed.pathname === '/about.htm') {e.preventDefault();shell.openExternal(parsed.href)}})

session.defaultSession.webRequest.onHeadersReceived((details, callback) => {callback({responseHeaders: Object.assign({"Content-Security-Policy": ["frame-ancestors 'none'"]}, details.responseHeaders)})})
session.defaultSession.webRequest.onBeforeRequest(function(details, callback){
const whitelist = /(^https:\/\/evilgames.eu)|(^devtools:\/\/devtools\/bundled\/)/g;
if(whitelist.test(details.url)){callback({cancel:false})}
else{callback({cancel:true})}})

win.on('close', (e) => {const choice = dialog.showMessageBoxSync(win,quitDialog);if(choice == 1){e.preventDefault()}})
win.on('closed', () => {app.exit()})})